﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.IO;

namespace YumeNikkiRandomizer
{
    class Command : RPGByteData
    {
        public int opcode = 0;
        public int indent = 0;
        public string stringArg = "";
        public int[] args;
        
        int moveRouteTarget;
        int moveRouteFreq;
        bool moveRouteRepeat;
        bool moveRouteSkip;
        MoveRoute moveRoute;
        
        #region // Command Codes //
        
        public static int C_TERMINATOR = 0;
        public static int C_BLANK = 10;
        public static int C_BATTLECALLEVENT = 1005;
        public static int C_FORCEFLEE = 1006;
        public static int C_ENABLECOMBO = 1007;
        public static int C_CHANGECLASS = 1008;
        public static int C_CHANGEBATTLECOMMANDS = 1009;
        public static int C_CALLLOAD = 5001;
        public static int C_EXITGAME = 5002;
        public static int C_TOGGLEATBMODE = 5003;
        public static int C_TOGGLEFULLSCREEN = 5004;
        public static int C_OPENVIDEOOPTIONS = 5005;
        public static int C_MESSAGE = 10110;
        public static int C_MESSAGEFOLLOW = 20110;
        public static int C_MESSAGEOPTIONS = 10120;
        public static int C_CHANGEFACE = 10130;
        public static int C_CHOICE = 10140;
        public static int C_CHOICECASE = 20140;
        public static int C_ENDCASE = 20141;
        public static int C_INPUTNUMBER = 10150;
        public static int C_SWITCH = 10210;
        public static int C_VARIABLE = 10220;
        public static int C_TIMER = 10230;
        public static int C_CHANGEMONEY = 10310;
        public static int C_CHANGEITEMS = 10320;
        public static int C_CHANGEPARTY = 10330;
        public static int C_CHANGEEXP = 10410;
        public static int C_CHANGELEVEL = 10420;
        public static int C_CHANGESTATS = 10430;
        public static int C_CHANGESKILLS = 10440;
        public static int C_CHANGEEQUIP = 10450;
        public static int C_CHANGEHP = 10460;
        public static int C_CHANGEMP = 10470;
        public static int C_CHANGESTATE = 10480;
        public static int C_FULLRECOVER = 10490;
        public static int C_DAMAGE = 10500;
        public static int C_NAMECHANGE = 10610;
        public static int C_TITLECHANGE = 10620;
        public static int C_CHARSETCHANGE = 10630;
        public static int C_FACESETCHANGE = 10640;
        public static int C_VEHICLEGRAPHIC = 10650;
        public static int C_SYSTEMBGMCHANGE = 10660;
        public static int C_SYSTEMSOUNDCHANGE = 10670;
        public static int C_SYSTEMGRAPHICSCHANGE = 10680;
        public static int C_TRANSITIONCHANGE = 10690;
        public static int C_BATTLESTART = 10710;
        public static int C_BATTLEWINCASE = 20710;
        public static int C_BATTLEFLEECASE = 20711;
        public static int C_BATTLELOSECASE = 20712;
        public static int C_BATTLEENDCASE = 20713;
        public static int C_OPENSHOP = 10720;
        public static int C_SHOPSALECASE = 20720;
        public static int C_SHOPCANCELCASE = 20721;
        public static int C_SHOPENDCASE = 20722;
        public static int C_CALLINN = 10730;
        public static int C_INNRESTCASE = 20730;
        public static int C_INNCANCELCASE = 20731;
        public static int C_INNENDCASE = 20732;
        public static int C_NAMEENTRY = 10740;
        public static int C_TELEPORT = 10810;
        public static int C_REMEMBERPLACE = 10820;
        public static int C_RESTOREPLACE = 10830;
        public static int C_RIDEVEHICLE = 10840;
        public static int C_PLACEVEHICLE = 10850;
        public static int C_PLACEEVENT = 10860;
        public static int C_SWAPEVENTS = 10870;
        public static int C_SETTERRAIN = 10910;
        public static int C_GETEVENTID = 10920;
        public static int C_ERASESCREEN = 11010;
        public static int C_SHOWSCREEN = 11020;
        public static int C_SCREENTONE = 11030;
        public static int C_SCREENFLASH = 11040;
        public static int C_SCREENSHAKE = 11050;
        public static int C_PANSCREEN = 11060;
        public static int C_WEATHER = 11070;
        public static int C_PICTURE = 11110;
        public static int C_MOVEPICTURE = 11120;
        public static int C_ERASEPICTURE = 11130;
        public static int C_SHOWANIMATION = 11210;
        public static int C_SETOPACITY = 11310;
        public static int C_FLASHEVENT = 11320;
        public static int C_MOVEEVENT = 11330;
        public static int C_MOVEALL = 11340;
        public static int C_STOPALL = 11350;
        public static int C_WAIT = 11410;
        public static int C_MUSIC = 11510;
        public static int C_FADEMUSIC = 11520;
        public static int C_REMEMBERMUSIC = 11530;
        public static int C_RESTOREMUSIC = 11540;
        public static int C_SOUND = 11550;
        public static int C_MOVIE = 11560;
        public static int C_KEYINPUT = 11610;
        public static int C_CHANGECHIPSET = 11710;
        public static int C_CHANGEPARALLAX = 11720;
        public static int C_CHANGEENCOUNTER = 11740;
        public static int C_CHANGECHIP = 11750;
        public static int C_SETTELEPORT = 11810;
        public static int C_DISABLETELEPORT = 11820;
        public static int C_SETESCAPE = 11830;
        public static int C_DISABLEESCAPE = 11840;
        public static int C_CALLSAVE = 11910;
        public static int C_DISABLESAVE = 11930;
        public static int C_CALLMENU = 11950;
        public static int C_DISABLEMENU = 11960;
        public static int C_FORK = 12010;
        public static int C_ELSE = 22010;
        public static int C_FORKEND = 22011;
        public static int C_LABEL = 12110;
        public static int C_LABELJUMP = 12120;
        public static int C_CYCLE = 12210;
        public static int C_CYCLEBREAK = 12220;
        public static int C_CYCLEEND = 22210;
        public static int C_STOPPARALLEL = 12310;
        public static int C_ERASEEVENT = 12320;
        public static int C_CALLEVENT = 12330;
        public static int C_COMMENT = 12410;
        public static int C_COMMENTFOLLOW = 22410;
        public static int C_GAMEOVER = 12420;
        public static int C_TITLE = 12510;
        public static int C_CHANGEENEMYHP = 13110;
        public static int C_CHANGEENEMYMP = 13120;
        public static int C_CHANGEENEMYSTATE = 13130;
        public static int C_ENEMYAPPEAR = 13150;
        public static int C_CHANGEBATTLEBG = 13210;
        public static int C_BATTLEANIMATION = 13260;
        public static int C_BATTLEFORK = 13310;
        public static int C_BATTLEELSE = 23310;
        public static int C_BATTLEFORKEND = 23311;
        public static int C_STOPBATTLE = 13410;
        #endregion
        
        public Command(FileStream f)
        {
            load(f);
        }
        public Command(int opcode, int indent, int[] args, string stringArg = "")
        {
            this.opcode = opcode;
            this.indent = indent;
            this.args = args;
            this.stringArg = stringArg;
        }
        public Command(int opcode, int indent, int moveRouteTarget, int moveRouteFreq, bool moveRouteRepeat, bool moveRouteSkip, MoveRoute moveRoute)
        {
            this.opcode = opcode;
            this.indent = indent;
            this.moveRouteTarget = moveRouteTarget;
            this.moveRouteFreq = moveRouteFreq;
            this.moveRouteRepeat = moveRouteRepeat;
            this.moveRouteSkip = moveRouteSkip;
            this.moveRoute = moveRoute;
        }
        public Command()
        {
        }
        
        // Loads a single command within a page.
        override public void load(FileStream f)
        {
            opcode = M.readMultibyte(f);
            indent = M.readMultibyte(f);
            
            int mode = getMode();
            
            if (opcode != C_MOVEEVENT)
            {
                int strType = mode != -1 && mode < M.FOLDERCOUNT? M.S_FILENAME : M.S_TOTRANSLATE;
                stringArg = M.readString(f, strType);
                int argCount = M.readMultibyte(f);
                args = new int[argCount];
                for (int i = 0; i < argCount; i++)
                    args[i] = M.readMultibyte(f);
            }
            else
            {
                M.byteCheck(f, 0x00);
                
                int moveLength = M.readMultibyte(f);
                int lengthTemp = moveLength;
                
                moveRouteTarget = M.readMultibyte(f);
                moveRouteFreq = M.readByte(f);
                moveRouteRepeat = (M.readByte(f) == 1);
                moveRouteSkip = (M.readByte(f) == 1);
                lengthTemp -= 4;
                
                moveRoute = new MoveRoute(f, lengthTemp, "Move");
            }
        }
        
        // Adds to warp list if teleport command.
        public void getWarps()
        {
            if (opcode != C_TELEPORT)
                return;
            
            int map = args[0];
            int x = args[1];
            int y = args[2];
            int dir = args.Length > 3? args[3] - 1 : -1; // 2003
            
            if (M.lastWarpMap != M.currentFile)
            {
                M.warpDefinitionList.WriteLine("");
                M.lastWarpMap = M.currentFile;
                M.lastWarpEvent = -1;
                M.lastWarpPage = -1;
                M.lastWarpSource = "";
                M.lastWarpDest = "";
            }
            
            if (M.currentFile.Contains("Map"))
            {
                int sourceMapNum = int.Parse(M.currentFile.Replace("Map", "").Replace(".lmu", ""));
                string sourceMapShort = "Map" + sourceMapNum;
                if (M.mapNames[sourceMapNum - 1] != null)
                    sourceMapShort = M.mapNames[sourceMapNum - 1].Replace(" ", "").Replace("-", "");
               
                if (M.lastWarpEvent == M.currentEventNum && M.lastWarpPage == M.currentPageNum)
                    M.warpMultipleCommandsCount++;
                else
                    M.warpMultipleCommandsCount = 1;
                string pageStr = M.currentPageNum.ToString() + (M.warpMultipleCommandsCount > 1? ", " + M.warpMultipleCommandsCount : "");
                
                string destMapShort = "Map" + map;
                if (M.mapNames[map - 1] != null)
                    destMapShort = M.mapNames[map - 1].Replace(" ", "").Replace("-", "");
                
                if (M.lastWarpSource.Equals(sourceMapShort) && M.lastWarpDest.Equals(destMapShort))
                    M.warpRepeatedNameCount++;
                else
                    M.warpRepeatedNameCount = 1;
                string nameSuffix = M.warpRepeatedNameCount > 1? "-" + M.warpRepeatedNameCount : "";
                M.lastWarpSource = sourceMapShort;
                M.lastWarpDest = destMapShort;
                
                M.warpDefinitionList.WriteLine("defineWarp(\"" + sourceMapShort + "/" + destMapShort + nameSuffix + "\", "
                    + "new MapLocation(" + sourceMapNum + ", " + M.currentEventNum + ", " + pageStr + "), "
                    + "new Warp(" + map + ", " + x + ", " + y + ", " + dir + "));");
                
                M.lastWarpEvent = M.currentEventNum;
                M.lastWarpPage = M.currentPageNum;
            }
            else
            {
                string destMapShort = "Map" + map;
                if (M.mapNames[map - 1] != null)
                    destMapShort = M.mapNames[map - 1].Replace(" ", "").Replace("-", "");
                
                M.warpDefinitionList.WriteLine("defineWarp(\"Common" + M.currentEventNum + "/" + destMapShort + "\", "
                    + "new CommonLocation(" + M.currentEventNum + "), "
                    + "new Warp(" + map + ", " + x + ", " + y + ", " + dir + "));");
            }
        }
        
        // Writes command data.
        override protected void myWrite()
        {
            M.writeMultibyte(opcode);
            M.writeMultibyte(indent);
            
            if (opcode != C_MOVEEVENT)
            {
                int mode = getMode();
                int strType = mode != -1 && mode < M.FOLDERCOUNT? M.S_FILENAME : M.S_TOTRANSLATE;
                
                M.writeString(stringArg, strType);
                M.writeMultibyte(args.Length);
                for (int i = 0; i < args.Length; i++)
                    M.writeMultibyte(args[i]);
            }
            else
            {
                M.writeByte(0x00);
                
                int totalMoveLength = moveRoute.getLength()
                                    + 1 // Target length, but it's always 1 regardless, I think...
                                    + 3; // Frequency, repeat, skip
                
                M.writeMultibyte(totalMoveLength);
                
                M.writeMultibyte(moveRouteTarget);
                M.writeByte(moveRouteFreq);
                M.writeByte(moveRouteRepeat? 1 : 0);
                M.writeByte(moveRouteSkip? 1 : 0);
                
                moveRoute.write();
            }
        }
        
        // Returns string handling mode based on opcode.
        int getMode()
        {
            int mode = -1;
            
            if (opcode == C_MESSAGE || opcode == C_MESSAGEFOLLOW)
                mode = M.M_MESSAGEALL;
            else if (opcode == C_COMMENT || opcode == C_COMMENTFOLLOW)
                mode = M.M_COMMENT;
            else if (opcode == C_CHARSETCHANGE || opcode == C_VEHICLEGRAPHIC)
                mode = M.M_CHARSET;
            else if (opcode == C_FACESETCHANGE || opcode == C_CHANGEFACE)
                mode = M.M_FACESET;
            else if (opcode == C_MUSIC || opcode == C_SYSTEMBGMCHANGE)
                mode = M.M_MUSIC;
            else if (opcode == C_SOUND || opcode == C_SYSTEMSOUNDCHANGE)
                mode = M.M_SOUND;
            else if (opcode == C_SYSTEMGRAPHICSCHANGE)
                mode = M.M_SYSTEM;
            else if (opcode == C_PICTURE)
                mode = M.M_PICTURE;
            else if (opcode == C_MOVIE)
                mode = M.M_MOVIE;
            else if (opcode == C_CHANGEPARALLAX)
                mode = M.M_PANORAMA;
            else if (opcode == C_BATTLESTART || opcode == C_CHANGEBATTLEBG)
                mode = M.M_BACKDROP;
            else if (opcode == C_CHOICE || opcode == C_CHOICECASE)
                mode = M.M_OPTION;
            else if (opcode == C_NAMECHANGE || opcode == C_FORK)
                mode = M.M_NAME;
            else if (opcode == C_TITLECHANGE)
                mode = M.M_NICKNAME;
            
            return mode;
        }
        
        // Returns whether the command is the ending command (opcode 0).
        public bool isEndCommand()
        {
            return opcode == C_TERMINATOR;
        }
    }
}
